//
//  MCReportModelBrowser.h
//  ReportBuilder
//
//  Created by Alykhan Jetha on 01/05/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//


#import <MCApplication/MCNibLoadingView.h>

@class MCPEntity;
@class MCReportElement;

@interface MCReportMBOperatorStub : NSObject {
	NSString *name;  // keypath @sum, @average, @min, @max ...
	NSString *displayName;
	NSString *resultKindName;
}

- (NSString *)name;
- (void)setName:(NSString *)aName;

- (NSString *)displayName;
- (void)setDisplayName:(NSString *)aDisplayName;

- (NSString *)resultKindName;
- (void)setResultKindName:(NSString *)aResultKindName;

// returns no
- (BOOL)isToMany;

@end


@interface MCReportModelBrowser : MCNibLoadingView {
	IBOutlet NSBrowser *browser;
		
	MCReportElement *targetReportElement;
	NSArray *viewHierarchyStack;
	
	NSArray *reportKeysSortDescriptors;
	
	IBOutlet NSTextField *keyPathField;
	IBOutlet NSTextField *prefixField;
	
	id doubleTarget;
	SEL doubleAction;
	
	id delegate;
	
	int mode;  // 0 == attribute, 1 == array
	
}

- (NSBrowser *)browser;

- (void)setDelegate:(id)aDelegate;

- (void)workInArrayMode;
- (void)workInAttributeMode;

- (void)setDoubleTarget:(id)aTarget;
- (void)setDoubleAction:(SEL)anAction;

- (NSArray *)reportKeysSortDescriptors;

- (MCReportElement *)targetReportElement;
- (void)setTargetReportElement:(MCReportElement *)aTargetReportElement;
- (void)setTargetReportElement:(MCReportElement *)aTargetReportElement insertFakeElement:(MCReportElement *)aFake;
- (void)configureForEntityOrClassname:(NSString *)aTypeString isToMany:(BOOL)flag displayName:(NSString *)aDisplayName;

- (NSArray *)viewHierarchyStack;
- (void)setViewHierarchyStack:(NSArray *)aViewHierarchyStack;

- (void)displayFirstColumn;
- (void)displayColumnAtPath:(NSString *)aPath;

- (BOOL)canGetKeyPath;

- (NSString *)currentResultKind;
- (NSString *)currentKeyPath;
- (NSString *)currentLabel;
- (int)currentFormatterCode;
- (NSString *)currentFormatterFormat;

- (void)writeSelectionToReportElement;

@end

@interface NSObject (MCReportModelBrowserDelegate)

- (void)modelBrowser:(MCReportModelBrowser *)aBrowser didSelectKeyPath:(NSString *)aKeypath prefixPath:(NSString *)aPrefix representedObject:(id)originalSource;

@end
